#pragma once

#include <infra/resource_cache_controller/libs/config/config.pb.h>

#include <infra/resource_cache_controller/libs/manager_factory/resource_cache_gc_manager.h>
#include <infra/resource_cache_controller/libs/manager_factory/resource_cache_manager.h>

#include <infra/libs/controller/standalone_controller/standalone_controller.h>

#include <library/cpp/proto_config/config.h>

namespace NInfra::NResourceCacheController {

TVector<NController::TSingleClusterObjectManagerFactoryPtr> CreateFactories(TStringBuf configJson) {
    auto config = NProtoConfig::ParseConfigFromJson<TConfig>(configJson);

    NInfra::NController::TSharding shardsFactory(config.GetController().GetLeadingInvader());
    return {
        new TResourceCacheManagerFactory(shardsFactory.GetShard(0))
        , new TResourceCacheGCManagerFactory(
           config.GetResourceCacheGCManagerFactory()
           , shardsFactory.GetShard(0)
        )
    };
}

class TStandaloneController: public NInfra::NController::TStandaloneController {
public:
    TStandaloneController(TStringBuf config)
        : NInfra::NController::TStandaloneController(
            NProtoConfig::ParseConfigFromJson<TConfig>(config).GetController()
            , CreateFactories(config)
        )
    {
    }
};

} // namespace NInfra::NResourceCacheController
