try:
    import argparse

    from infra.swatlib import cmdutil
    from infra.rsc.src.app import rsc
    from infra.rsc.src.version import VERSION
except KeyboardInterrupt:
    # don't bother user with python stack trace
    # if interrupted (by Ctrl+C) during imports
    raise SystemExit(1)


def init_arg_parser():
    p = argparse.ArgumentParser(description=rsc.Application.name)
    p.add_argument('-v', '--version',
                   action='version',
                   version=VERSION)
    p.add_argument('-c', '--cfg',
                   default=None,
                   action='store', help='path to service cfg file')
    # --console is used to dump logs during debugging with IDE
    # when stdout isn't terminal but we don't want to log to file
    p.add_argument('--console',
                   default=False,
                   action='store_true',
                   help='redirect log to stdout (overrides config)')
    p.add_argument('-d', '--debug',
                   default=False,
                   action='store_true',
                   help='do NOT daemonize, do NOT change working dir')
    return p


def main():
    cmdutil.main(init_arg_parser(), rsc.Application, env_prefix='RSC')


if __name__ == '__main__':
    main()
