from __future__ import unicode_literals
from datetime import datetime


class ClusterCondition(object):

    def __init__(self, cluster):
        self.cluster = cluster
        self.status = 'Unknown'
        self.reason = ''
        self.message = ''
        self.last_probe_time = None
        self.last_transition_time = None

    def set_ok(self, reason='', message=''):
        self.status = 'OK'
        self.reason = reason
        self.message = message
        self.last_probe_time = self.last_transition_time = datetime.utcnow()

    def set_failed(self, reason='', message=''):
        self.status = 'Failed'
        self.reason = reason
        self.message = message
        self.last_probe_time = self.last_transition_time = datetime.utcnow()

    def set_exception(self, exc=None):
        """
        :type exc: Exception | None
        """
        self.status = 'Failed'
        if exc:
            reason = 'EXCEPTION_HAPPENED'
            message = str(exc)
        else:
            reason = ''
            message = ''
        self.set_failed(reason, message)

    def __repr__(self):
        return '{}: {}'.format(self.status, self.message)
