from __future__ import unicode_literals


class PodLister(object):

    def __init__(self, rs_id, storage):
        """
        :type rs_id: str
        :type storage: infra.rsc.src.model.storage.PodIndexedStorage
        """
        self.rs_id = rs_id
        self.storage = storage

    def list_all(self):
        """
        :rtype: list[yp.data_model.TPod]
        """
        return self.storage.list_by_ps_id(self.rs_id)

    def list_by_ids(self, ids):
        """
        :type ids: list[str]
        :rtype: list[yp.data_model.TPod]
        """
        rv = []
        for p_id in ids:
            p = self.storage.get(p_id)
            if not p:
                continue
            rv.append(p)
        return rv

    def list_by_stage_id(self, stage_id, cluster=None):
        """
        :type stage_id: str
        :rtype: list[yp.data_model.TPod]
        """
        return self.storage.list_by_stage_id(stage_id)
