from __future__ import unicode_literals
import logging

from infra.swatlib.gevent import greenthread


class RscManager(greenthread.GreenThread):
    """Manages reflectors, runner and gc."""

    def __init__(self, rs_reflector, pod_set_reflector, pod_reflector,
                 ctl_runner, pod_set_gc):
        super(RscManager, self).__init__()
        self.rs_reflector = rs_reflector
        self.pod_set_reflector = pod_set_reflector
        self.pod_reflector = pod_reflector
        self.ctl_runner = ctl_runner
        self.pod_set_gc = pod_set_gc
        self.log = logging.getLogger('rsc_manager')

    def run(self):
        try:
            self.log.info("starting rs reflector...")
            self.rs_reflector.start()
            self.log.info("rs reflector started")

            self.log.info("starting pod_set reflector...")
            self.pod_set_reflector.start()
            self.log.info("pos_set reflector started")

            self.log.info("starting pod reflector...")
            self.pod_reflector.start()
            self.log.info("pod reflector started")

            self.log.info("starting pod_set gc...")
            self.pod_set_gc.start()
            self.log.info("pod_set gc started")

            self.log.info("starting ctl runner...")
            self.ctl_runner.start()
            self.log.info("ctl runner started. Waiting infinitely...")
            # Block here.
            self.ctl_runner.wait()
        finally:
            self.log.info("stopping rs reflector...")
            self.rs_reflector.stop()
            self.log.info("rs reflector stopped")

            self.log.info("stopping pod_set reflector...")
            self.pod_set_reflector.stop()
            self.log.info("pos_set reflector stopped")

            self.log.info("stopping pod reflector...")
            self.pod_reflector.stop()
            self.log.info("pod reflector stopped")

            self.log.info("stopping pod_set gc...")
            self.pod_set_gc.stop()
            self.log.info("pod_set gc stopped")

            self.log.info("stopping ctl runner...")
            self.ctl_runner.stop()
            self.log.info("ctl runner stopped")
