from __future__ import unicode_literals
import re

from infra.rsc.src.lib import podutil
from infra.swatlib.gevent import geventutil as gutil


ENUMERATED_POD_ID_RE = re.compile('^[a-z][a-z0-9-]{0,31}$')


class RandomPodIdGenerator(object):

    def generate(self):
        return podutil.gen_pod_id()


RANDOM_POD_ID_GENERATOR = RandomPodIdGenerator()


class EnumeratedPodIdGenerator(object):
    __slots__ = ('stage_id', 'max_replica_num')

    def __init__(self, stage_id, max_replica_num):
        self.stage_id = stage_id
        self.max_replica_num = max_replica_num

    def generate(self):
        self.max_replica_num += 1
        return '{}-{}'.format(self.stage_id, self.max_replica_num)


def is_enumerated_pod_id_allowed(stage_id):
    return ENUMERATED_POD_ID_RE.match(stage_id) is not None


def make_pod_id_generator(rs, pod_lister, cluster=None):
    # For now we use random pod_id generator always:
    # https://st.yandex-team.ru/DEPLOY-1063
    return RANDOM_POD_ID_GENERATOR

    stage_id = podutil.get_stage_id_from_rs(rs)
    if not is_enumerated_pod_id_allowed(stage_id):
        return RANDOM_POD_ID_GENERATOR

    pods = pod_lister.list_by_stage_id(stage_id, cluster)
    max_replica_num = 0
    for p in gutil.gevent_idle_iter(pods):
        replica_num = podutil.get_replica_num_from_pod_id(p.meta.id)
        if replica_num is None:
            # Ignore pod ids without replica_num
            continue
        if max_replica_num < replica_num:
            max_replica_num = replica_num

    return EnumeratedPodIdGenerator(stage_id, max_replica_num)
