from __future__ import unicode_literals

import yp.data_model
from infra.swatlib.gevent import geventutil as gutil
from infra.rsc.src.model import consts


class PodMaker(object):

    def __init__(self, root_users, match_labels):
        self.match_labels = match_labels
        self.default_acl = [self.make_default_access_control_entry(root_users)]

    @staticmethod
    def make_default_access_control_entry(users):
        rv = yp.data_model.TAccessControlEntry()
        rv.action = yp.data_model.ACA_ALLOW
        rv.permissions.extend([yp.data_model.ACP_READ,
                               yp.data_model.ACA_WRITE,
                               yp.data_model.ACA_CREATE,
                               yp.data_model.ACA_SSH_ACCESS,
                               yp.data_model.ACA_ROOT_SSH_ACCESS])
        rv.subjects.extend(users)
        return rv

    def make_pod_template(self, rs):
        p = yp.data_model.TPod()
        p.meta.inherit_acl = True
        p.meta.pod_set_id = rs.meta.id
        p.labels.CopyFrom(self.match_labels)
        p.labels.MergeFrom(rs.spec.pod_template_spec.labels)
        p.spec.CopyFrom(rs.spec.pod_template_spec.spec)
        p.spec.enable_scheduling = True
        return p

    def make_pods(self, rs, count, pod_id_generator):
        pods = []
        template = self.make_pod_template(rs)
        for _ in gutil.gevent_idle_iter(range(count)):
            p = yp.data_model.TPod()
            p.CopyFrom(template)
            p_id = pod_id_generator.generate()
            p.meta.id = p_id
            p.spec.pod_agent_payload.spec.id = p_id
            pods.append(p)
        return pods

    def get_constraints(self, rs, cluster=None):
        return rs.spec.constraints

    def make_pod_set(self, rs, cluster=None):
        ps = yp.data_model.TPodSet()
        ps.labels.MergeFrom(self.match_labels)

        ps.meta.id = rs.meta.id
        ps.meta.acl.MergeFrom(self.default_acl)
        ps.meta.acl.MergeFrom(rs.meta.acl)

        ps.spec.account_id = rs.spec.account_id
        ps.spec.node_segment_id = (rs.spec.node_segment_id or
                                   consts.DEFAULT_NODE_SEGMENT_ID)
        ps.spec.antiaffinity_constraints.MergeFrom(
            self.get_constraints(rs, cluster).antiaffinity_constraints
        )
        return ps
