from collections import defaultdict
import time


class RateLimiter(object):
    def __init__(self, enabled=False, delay_secs=60):
        self.delay_secs = delay_secs
        self.last_process_time = defaultdict(int)
        self.enabled = enabled

    def update_last_process_time(self, rs_id):
        self.last_process_time[rs_id] = int(time.time() + 1)

    def is_process_allowed(self, rs_id):
        return not self.enabled or self.last_process_time[rs_id] + self.delay_secs < int(time.time())
