from __future__ import unicode_literals

import yt.yson as yson
from infra.rsc.src.lib import podutil


def validate_pod_set_labels(ps, match_labels):
    d = podutil.make_dict_from_labels(ps.labels)
    diff = []
    for a in match_labels.attributes:
        v = yson.loads(a.value)
        ps_v = d.get(a.key)
        if v != ps_v:
            diff.append('{}: {} != {}'.format(a.key, ps_v, v))
    if not diff:
        return

    diff_s = ', '.join(diff)
    raise ValueError('Wrong labels in pod_set: {}: {}'.format(ps.meta.id,
                                                              diff_s))
