from __future__ import unicode_literals

import yaml

import yp.client
import yp.common
import yt_yson_bindings
from google.protobuf import json_format
from infra.rsc.src.lib import credentials
from sepelib.core import config
import yp.data_model as data_model
from yp_proto.yp.client.api.proto import object_service_pb2


def recreate_rs():
    c = yp.client.YpClient(
        address=config.get_value('yp.address'),
        config={
            'token': credentials.get_token(),
            'user': credentials.get_user(),
        },
    )
    stub = c.create_grpc_object_stub()
    rs = data_model.TReplicaSet()
    with open('rs.yml') as fd:
        d = yaml.load(fd)
    json_format.ParseDict(d, rs)
    import random
    d = random.randint(0, 2 ** 30)
    rs.spec.pod_template_spec.spec.pod_agent_payload.spec.Revision = d
    a = rs.meta.acl.add()
    a.action = data_model.ACA_ALLOW
    a.permissions.extend([data_model.ACP_READ,
                          data_model.ACA_WRITE,
                          data_model.ACA_CREATE,
                          data_model.ACA_SSH_ACCESS,
                          data_model.ACA_ROOT_SSH_ACCESS])
    a.subjects.append(credentials.get_user())
    r = object_service_pb2.TReqRemoveObject()
    r.object_type = data_model.OT_REPLICA_SET
    r.object_id = rs.meta.id
    try:
        stub.RemoveObject(r)
    except yp.common.YpNoSuchObjectError:
        pass
    r = object_service_pb2.TReqCreateObject()
    r.object_type = data_model.OT_REPLICA_SET
    r.attributes = yt_yson_bindings.dumps_proto(rs)
    stub.CreateObject(r)
