package cmd

import (
	"fmt"
	"path/filepath"

	"a.yandex-team.ru/infra/rsm/coroner/internal/app/coroner"
	log "a.yandex-team.ru/infra/rsm/coroner/internal/logger"
	"a.yandex-team.ru/library/go/core/buildinfo"

	"github.com/spf13/cobra"
)

const (
	defaultLogDir  = ""
	defaultLogName = "coroner.log"
)

var (
	c       coroner.Config
	rootCmd = &cobra.Command{
		Use:   "coroner",
		Short: "Coroner server",
		Long: `Coroner server,
			Wiki: https://wiki.yandex-team.ru/kernel/#coroner
			Docs: https://a.yandex-team.ru/arc/trunk/arcadia/infra/coroner/README.md`,
		Version: buildinfo.Info.ProgramVersion,
		PersistentPreRunE: func(cmd *cobra.Command, args []string) error {
			logPath := ""
			if c.LogDir != "" {
				logPath = filepath.Join(c.LogDir, c.LogName)
			}
			return log.SetupLogger(logPath, c.Level)
		},
	}
)

func Execute() {
	rootCmd.PersistentFlags().StringVarP(&c.LogDir, "log_dir", "l", defaultLogDir, "path to log files")
	rootCmd.PersistentFlags().StringVarP(&c.LogName, "log_name", "n", defaultLogName, "name of log files")
	rootCmd.PersistentFlags().CountVarP(&c.Level, "debug", "d", "-ddd - debug, -dd - info, -d - error. Default -d")

	if buildinfo.Info.ProgramVersion == "" {
		rootCmd.Version = "N/A"
	} else {
		rootCmd.Version = buildinfo.Info.ProgramVersion
	}

	if err := rootCmd.Execute(); err != nil {
		fmt.Println(err)
	}
}
