package cmd

import (
	"a.yandex-team.ru/infra/rsm/coroner/internal/app/coroner"
	"github.com/spf13/cobra"
)

var (
	runCmd = &cobra.Command{
		Use:   "run",
		Short: "Run coroner server",
		Run:   func(cmd *cobra.Command, args []string) { coroner.Run(&c) },
	}
)

func init() {
	runCmd.PersistentFlags().StringVar(&c.YasmItype, "yasm_itype", "runtimecloud", "yasm itype")
	runCmd.PersistentFlags().StringVar(&c.YasmCtype, "yasm_ctype", "none", "yasm ctype")
	runCmd.PersistentFlags().StringVar(&c.YasmPrj, "yasm_prj", "none", "yasm prj")
	runCmd.PersistentFlags().StringVar(&c.YasmGeo, "yasm_geo", "none", "yasm geo")
	runCmd.PersistentFlags().StringVar(&c.YasmHost, "yasm_host", "localhost", "yasm server hostname")
	runCmd.PersistentFlags().IntVar(&c.YasmPort, "yasm_port", 11005, "yasm server port")
	runCmd.PersistentFlags().IntVar(&c.HTTPPort, "http_port", 80, "http port")
	runCmd.PersistentFlags().IntVar(&c.UDPPort, "udp_port", 6666, "netconsole port")
	rootCmd.PersistentFlags().StringVar(&c.LBDir, "lbdir", "/logbroker-playground/coroner", "path to LB dir")
	rootCmd.AddCommand(runCmd)
}
