package cmd

import (
	"fmt"
	"strings"

	ctl "a.yandex-team.ru/infra/rsm/coroner/internal/app/coronerctl"
	log "a.yandex-team.ru/infra/rsm/coroner/internal/logger"

	"github.com/spf13/cobra"
)

var (
	aliasCmd = &cobra.Command{
		Use: "alias",
		Run: func(cmd *cobra.Command, args []string) { runAliasCmd() },
	}
	listCmd = &cobra.Command{
		Use: "l",
		Run: func(cmd *cobra.Command, args []string) { runListCmd() },
	}
	aliasName string
)

func init() {
	aliasCmd.Flags().StringVarP(&aliasName, "name", "n", "", "name of alias")
	aliasCmd.AddCommand(listCmd)
	rootCmd.AddCommand(aliasCmd)
}

func runAliasCmd() {
	alias, err := ctl.MakeMap(ctl.Config, "alias")
	if err != nil {
		log.L.Errorf("%s", err)
	}
	param, ok := alias[aliasName]
	if ok {
		log.L.Debugf("Run coronerctl %s", param)
	} else {
		log.L.Fatalf("Alias not found")
	}
	rootCmd.SetArgs(strings.Fields(param))
	if err := rootCmd.Execute(); err != nil {
		log.L.Errorf("%s", err)
	}
}

func runListCmd() {
	alias, err := ctl.MakeMap(ctl.Config, "alias")
	if err != nil {
		log.L.Errorf("%s", err)
	}
	for k, v := range alias {
		fmt.Println(k, " : ", v)
	}
}
