package cmd

import (
	"fmt"
	"strings"

	ctl "a.yandex-team.ru/infra/rsm/coroner/internal/app/coronerctl"
	log "a.yandex-team.ru/infra/rsm/coroner/internal/logger"

	"github.com/spf13/cobra"
)

var (
	digestCmd = &cobra.Command{
		Use: "digest",
		Run: func(cmd *cobra.Command, args []string) { runDigitCmd() },
	}
	digestName string
)

func init() {
	digestCmd.Flags().StringVarP(&digestName, "name", "n", "", "name of digest (rtc_digest, mds_digest)")
	rootCmd.AddCommand(digestCmd)
}

func runDigitCmd() {
	alias, err := ctl.MakeMap("digest.ini", digestName)
	if err != nil {
		log.L.Errorf("%s", err)
	}
	for k, v := range alias {
		rootCmd.SetArgs(strings.Fields(v))
		if err := rootCmd.Execute(); err != nil {
			log.L.Errorf("%s", err)
		}
		fmt.Printf("%s:\n%s", k, ctl.TextData)
	}
}
