package cmd

import (
	"os"
	"strings"

	ctl "a.yandex-team.ru/infra/rsm/coroner/internal/app/coronerctl"
	log "a.yandex-team.ru/infra/rsm/coroner/internal/logger"

	"github.com/spf13/cobra"
)

var (
	rawCmd = &cobra.Command{
		Use: "raw",
		Run: func(cmd *cobra.Command, args []string) { runRawCmd() },
	}
	from   string
	output string
	limit  int
)

func init() {
	rawCmd.Flags().StringVar(&opts.Use, "db", ctl.CHYTName, "set YT DB path")
	rawCmd.Flags().StringVar(&from, "table", ctl.RawTable, "set YT Table path")
	rawCmd.Flags().StringVarP(&opts.T, "time", "t", "3d", "filter by time (3d-now, 1m, 22.04-18.09T15:05)")
	rawCmd.Flags().StringVarP(&output, "output", "o", "raw", "output format (table, json, yaml, raw)")
	rawCmd.Flags().IntVarP(&limit, "limit", "l", 20000, "maximum number of returned lines")
	rawCmd.Flags().BoolVar(&opts.Dryrun, "dryrun", false, "dryrun mode. Only makes request and print then")
	rawCmd.Flags().StringVarP(&opts.Host, "host", "H", "", "host (sas1-3333.search.yandex.net,)")
	rootCmd.AddCommand(rawCmd)
}

func runRawCmd() {
	opts.From = from
	opts.Output = output
	opts.Limit = limit
	if opts.Host != "" {
		opts.Host = strings.Split(opts.Host, ",")[0]
		opts.Columns = "ts,data"
		opts.Sortby = "ts"
	} else {
		log.L.Fatalf("Use key -H")
	}
	if err := ctl.Run(opts, os.Stdout); err != nil {
		log.L.Fatalf("%s", err)
	}
}
