package coronerctl

import (
	"errors"
	"os/user"
	"path"

	log "a.yandex-team.ru/infra/rsm/coroner/internal/logger"
	"a.yandex-team.ru/library/go/core/resource"

	"gopkg.in/ini.v1"
)

const (
	Config = "config.ini"
)

func parseSection(cfg *ini.File, section string, alias map[string]string) {
	keys := cfg.Section(section).KeyStrings()
	for _, k := range keys {
		alias[k] = cfg.Section(section).Key(k).String()
		log.L.Debugf("%s : %s", k, alias[k])
	}
}

func MakeMap(confResource, section string) (map[string]string, error) {
	var alias = map[string]string{}
	cfg, err := ini.Load(resource.Get(confResource))
	if err != nil {
		return alias, err
	}
	parseSection(cfg, section, alias)
	if confResource != Config {
		if len(alias) == 0 {
			return alias, errors.New("section not found")
		}
		return alias, nil
	}
	usr, err := user.Current()
	if err != nil {
		return alias, err
	}
	homePath := usr.HomeDir
	cfg, err = ini.Load(path.Join(homePath, ".coronerctl.ini"))
	if err != nil {
		log.L.Debugf("Custom alias not found. Error: %s", err)
	} else {
		parseSection(cfg, "alias", alias)
	}
	return alias, nil
}
