package coronerctl

import (
	"bytes"
	"io"
	"strings"
)

func MakeRawQuery(limit int64, host string) (string, error) {
	opts := &Opts{
		Host:    host,
		From:    RawTable,
		Columns: "ts,data",
		Dryrun:  false,
		Use:     CHYTName,
		T:       "1d",
		Level:   1,
		Limit:   10000,
	}
	if limit == 0 {
		opts.Sortby = "ts"
		opts.Output = "raw"
	} else {
		opts.Sortby = "TS"
		opts.Output = "ui"
	}
	var buf bytes.Buffer
	rw := io.ReadWriter(&buf)
	if err := Run(opts, rw); err != nil {
		return "", err
	}
	b, err := io.ReadAll(rw)
	if err != nil {
		return "", err
	}
	if limit == 0 {
		return string(b[:]), nil
	} else {
		if int64(len(b)) >= limit {
			b = b[:limit]
		}
		reverseAgregator := strings.Split(string(b), "\n")
		return dataReverse(reverseAgregator), nil
	}
}

func dataReverse(agregator []string) string {
	for i, j := 0, len(agregator)-1; i < j; i, j = i+1, j-1 {
		agregator[i], agregator[j] = agregator[j], agregator[i]
	}
	return strings.Join(agregator, "\n")
}
