package logger

import (
	"syscall"

	"a.yandex-team.ru/library/go/core/log"
	"a.yandex-team.ru/library/go/core/log/zap"
	"a.yandex-team.ru/library/go/core/log/zap/logrotate"
)

const (
	logrotateSignal = syscall.SIGHUP
	defaultLevel    = 2
)

var (
	L   *zap.Logger
	err error
)

func SetupLogger(logPath string, level int) error {
	switch level {
	case 2:
		level = 2
	case 3:
		level = 1
	default:
		level = 3
	}
	logLevel := log.Level(level)
	cfg := zap.ConsoleConfig(logLevel)
	cfg.DisableStacktrace = true
	if logPath != "" {
		err := logrotate.RegisterLogrotateSink(logrotateSignal)
		if err != nil {
			return err
		}
		cfg.OutputPaths = []string{"logrotate://" + logPath}
		cfg.ErrorOutputPaths = []string{logPath}
	}
	L, err = zap.New(cfg)
	if err != nil {
		return err
	}
	return nil
}
