package internal

import (
	"context"
	"os"
	"os/signal"
)

func WaitForSignal(sigs []os.Signal) os.Signal {
	done := make(chan os.Signal, 1)
	signal.Notify(done, sigs...)
	return <-done
}

func WithCancelOnSignal(ctx context.Context, stopSignals []os.Signal) (context.Context, context.CancelFunc) {
	ctx, cancel := context.WithCancel(ctx)

	go func() {
		WaitForSignal(stopSignals)
		cancel()
	}()

	return ctx, cancel
}
