#!/usr/bin/env bash
# -*- coding: utf-8 -*-

FQDN=$(hostname -f)
JUGGLER_URL="http://localhost:31579/events"
CMD="./coronerctl"
TIME="1800"

function push_event() {
    # truncate string
    desc=$(printf '%s' "${2:0:730}" | tr -d "\"")
    data='{"source":"'$1'","events":[{"description":"'$desc'","host":"'$FQDN'","instance":"","service":"'$1'","status":"'$3'","tags":["coroner"]}]}'
    curl -o /dev/nul -s -X POST -d "$data" $JUGGLER_URL
}

function run() {
	cmd_args="-t $(($TIME/60))M -c name,rip,kernel,wq $2 --sumby name -o json -q"
	# get json
	out=$($CMD $cmd_args 2>&1)
	if [ $? -ne 0 ]; then
			push_event $1 "$out" "WARN"
			return
	fi
	# check json
	err=$(echo $out | json_pp 2>&1)
	if [ $? -ne 0 ]; then
			echo "out: $out"
			echo "err: $err"
			push_event $1 "$err" "CRIT"
			return
	fi
	# check length
	if [ "$out" != "[]" ]; then
			data=$(echo $out | tr -d '"[]' | sed -e 's/,/, /g')
			push_event $1 "$data" "CRIT"
			return
	fi
	push_event $1 "" "OK"
}

while true; do
	sleep $TIME
	# RTC
	run "digest" "-N gpf,bug,workqueue_lockup,panic"
	# MDS (KERNEL-696)
	run "mds_digest" "-P mds,mds-logshatter,mds-collector,mds-lepton,cocaine-back,cocaine,resizer,avatars,mds-proxy,mds-storage,mds-testing,mds-test-storage"
done
