package cmd

import (
	//"fmt"
	"context"

	"github.com/spf13/cobra"
	"go.uber.org/zap"

	pb "a.yandex-team.ru/infra/rsm/diskmanager/api"
)

// daemonStatCmd represents the daemonStat command
var daemonStatCmd = &cobra.Command{
	Use:   "daemon_stat",
	Short: "Get daemon stats",
	RunE: func(cmd *cobra.Command, args []string) error {
		return doDaemonStat()
	},
}

func init() {
	rootCmd.AddCommand(daemonStatCmd)
	daemonStatCmd.Flags().BoolVarP(&dumpJSON, "json", "J", false, "Json output format")
}

func doDaemonStat() error {
	ctx := context.Background()
	r, err := client.Client.DaemonGetStat(ctx, &pb.DaemonGetStatRequest{})
	if err != nil {
		client.Log.Fatal("req fail", zap.Error(err))
		return err
	}
	client.Log.Debug("return", zap.Any("reply", r))
	return nil
}
