package cmd

import (
	"context"
	"fmt"

	"github.com/spf13/cobra"

	pb "a.yandex-team.ru/infra/rsm/diskmanager/api"
)

// serverInfoCmd represents the serverInfo command
var serverInfoCmd = &cobra.Command{
	Use:   "server_info",
	Short: "Get server info",
	RunE: func(cmd *cobra.Command, args []string) error {
		return doServerInfo()
	},
}

func init() {
	rootCmd.AddCommand(serverInfoCmd)
	serverInfoCmd.Flags().BoolVarP(&dumpJSON, "json", "J", false, "Json output format")
}

func doServerInfo() error {
	ctx := context.Background()
	r, err := client.Client.ServerInfo(ctx, &pb.ServerInfoRequest{})
	if err != nil {
		return err
	}
	fmt.Printf("Id: %s\n", r.Id)
	fmt.Printf("Pid: %d\n", r.MainPid)
	fmt.Printf("Version:%s\n", r.Version)
	return nil
}
