package diskmanager

type Configuration struct {
	/* TODO Add json tags here */
	GrpcEndpoint   string
	LogFile        string
	YasmProdURL    string
	YasmProdCType  string
	YasmProdProj   string
	YasmPushPeriod uint32

	FstrimPeriod     uint32
	FstrimWaitFactor uint32
	QuotaSyncPeriod  uint32
}

type Options struct {
	GrpcEndpoint   string
	LogFile        string
	YasmProdURL    string
	YasmProdCType  string
	YasmProdProj   string
	YasmPushPeriod uint32

	FstrimPeriod     uint32
	FstrimWaitFactor uint32
	QuotaSyncPeriod  uint32
}

type Option func(c *Options)

var (
	DefaultConfiguration = Configuration{
		GrpcEndpoint:   DefaultServerAddress,
		LogFile:        DefaultServerLog,
		YasmProdURL:    DefaultYasmProdURL,
		YasmProdCType:  DefaultYasmProdCType,
		YasmProdProj:   DefaultYasmPRodProj,
		YasmPushPeriod: DefaultYasmPushPeriod,

		FstrimPeriod:     DefaultFstrimPeriod,
		FstrimWaitFactor: DefaultFstrimWaitFactor,

		QuotaSyncPeriod: DefaultQuotaSyncPeriod,
	}
)

func (c *Configuration) applyOptions(options ...Option) Options {
	opts := Options{
		GrpcEndpoint:     c.GrpcEndpoint,
		LogFile:          c.LogFile,
		YasmProdURL:      c.YasmProdURL,
		YasmProdCType:    c.YasmProdCType,
		YasmProdProj:     c.YasmProdProj,
		YasmPushPeriod:   c.YasmPushPeriod,
		FstrimPeriod:     c.FstrimPeriod,
		FstrimWaitFactor: c.FstrimWaitFactor,
		QuotaSyncPeriod:  c.QuotaSyncPeriod,
	}
	for _, option := range options {
		option(&opts)
	}
	/* TODO fixup default values here */
	return opts
}

func (c *Configuration) NewDiskmanager(options ...Option) (*Diskmanager, error) {
	opts := c.applyOptions(options...)

	return NewDiskmanager(opts)
}
