package diskmanager

const (
	DefaultServerUnixSock  = "/run/diskman.sock"
	DefaultServerAddress   = "unix:" + DefaultServerUnixSock
	DefaultSockPermissions = 0o664
	DefaultServerConf      = "/etc/diskmanager.conf"
	DefaultServerLog       = "/var/log/yandex-diskmanager.log"

	// Yasm config
	DefaultYasmProdURL    = "http://localhost:11005"
	DefaultYasmProdCType  = "prod"
	DefaultYasmPRodProj   = "diskmanager"
	DefaultYasmTestURL    = "http://localhost:100229"
	DefaultYasmPushPeriod = 5

	// Fstrim
	DefaultFstrimPeriod = 600
	// Max size is equals to flex group size (8 basic groups, 128Mb each)
	DefaultFstrimMaxChunk = 1 << 30
	//Min size is equals to typical erasure SSD block
	DefaultFstrimMinChunk = 128 << 10
	// Speed_factor X10
	DefaultFstrimWaitFactor = 10

	// sync quotas each hour
	DefaultQuotaSyncPeriod = 3600

	// IOLimits Minimal possible ops bounds
	DefaultIOLimReadIOpsMin  = 5
	DefaultIOLimWriteIOpsMin = 5
	DefaultIOLimReadBpsMin   = 1 << 20
	DefaultIOLimWriteBpsMin  = 2 << 20

	// User creds
	DefaultUserID  = 0
	DefaultGroupID = 1334
	DefaultWikiURL = "https://wiki.yandex-team.ru/runtime-cloud/disk-manager"
	DefaultDocURL  = "https://a.yandex-team.ru/arc/trunk/arcadia/infra/diskmanager/README.md"
)
