package diskmanager

import (
	"a.yandex-team.ru/infra/rsm/diskmanager/internal/ilog"
	"go.uber.org/zap"
	"google.golang.org/grpc/codes"
	"google.golang.org/grpc/status"
)

// disk package errors
var (
	ErrBadDiskState   = status.Error(codes.FailedPrecondition, "bad disk state")
	ErrBadVolumeState = status.Error(codes.FailedPrecondition, "bad volume state")
)

func GRPCErr(err error) error {
	if err == nil {
		return nil
	}
	if _, ok := status.FromError(err); !ok {
		ilog.Log().Error("Non grpc error leak detected", zap.Error(err))
		return status.Error(codes.Internal, err.Error())
	}
	return err
}
