package diskmanager_test

import (
	"fmt"
	"testing"

	"github.com/stretchr/testify/assert"
	"google.golang.org/grpc/codes"
	"google.golang.org/grpc/status"

	"a.yandex-team.ru/infra/rsm/diskmanager/internal/diskmanager"
)

func TestErrConvert(t *testing.T) {
	e1 := status.Error(codes.Unimplemented, "some value")
	assert.Equal(t, e1, diskmanager.GRPCErr(e1))

	e2 := fmt.Errorf("my error")
	assert.Equal(t, status.Error(codes.Internal, "my error"), diskmanager.GRPCErr(e2))

}
