package utils

import (
	"fmt"
	"strconv"
	"strings"
)

func ParseUint32(s string) (uint32, error) {
	num, err := strconv.ParseUint(s, 10, 32)
	if err != nil {
		return 0, err
	}
	return uint32(num), nil
}

func ParseMajMin(dev string) (uint64, error) {
	mm := strings.Split(dev, ":")

	if len(mm) != 2 {
		return 0, fmt.Errorf("'%s' failed: unexpected minor:major pair %s", dev, mm)
	}
	major, err := ParseUint32(mm[0])
	if err != nil {
		return 0, err
	}
	minor, err := ParseUint32(mm[1])
	if err != nil {
		return 0, err
	}
	return Mkdev(major, minor), nil
}

func FormatMajorMinor(mm uint64) string {
	return fmt.Sprintf("%d:%d", Major(mm), Minor(mm))
}

/* TODO Remove explicit major/minor functions */
func Major(dev uint64) uint32 {
	major := uint32((dev & 0x00000000000fff00) >> 8)
	major |= uint32((dev & 0xfffff00000000000) >> 32)
	return major
}

func Minor(dev uint64) uint32 {
	minor := uint32((dev & 0x00000000000000ff) >> 0)
	minor |= uint32((dev & 0x00000ffffff00000) >> 12)
	return minor
}
func Mkdev(major, minor uint32) uint64 {
	dev := (uint64(major) & 0x00000fff) << 8
	dev |= (uint64(major) & 0xfffff000) << 32
	dev |= (uint64(minor) & 0x000000ff) << 0
	dev |= (uint64(minor) & 0xffffff00) << 12
	return dev
}

func Find(slice []string, val string) (int, bool) {
	for i, item := range slice {
		if item == val {
			return i, true
		}
	}
	return -1, false
}
