package bugon

import (
	"os"
	"testing"

	"github.com/stretchr/testify/assert"
)

func wrapStderr(new *os.File) func() {
	orig := os.Stderr
	os.Stderr = new
	return func() { os.Stderr = orig }
}

func TestBugon(t *testing.T) {
	// Redirect to stdout, because stderr logged unconditiantly
	undo := wrapStderr(os.Stdout)
	defer undo()

	assert.Panics(t, func() { BUGON(true, "force bugon") })
	assert.Panics(t, func() { BUGON(1 != 2, "force bugon") })
	assert.NotPanics(t, func() { BUGON(false, "no bugon") })
	assert.NotPanics(t, func() { BUGON(0 > 1, "no bugon") })
}
