package cleanup_test

import (
	"a.yandex-team.ru/infra/rsm/diskmanager/pkg/cleanup"
	"errors"
	"github.com/stretchr/testify/assert"
	"testing"
)

func f0(a *[]string, clog *cleanup.Steps, err error) {
	*a = append(*a, "enter-f0")
	defer func() {
		clog.Add(func() error {
			*a = append(*a, "exit-f0")
			return err
		})
	}()
}

func f1(a *[]string, clog *cleanup.Steps, err error) {
	*a = append(*a, "enter-f1")
	f0(a, clog, nil)
	defer func() {
		clog.Add(func() error {
			*a = append(*a, "exit-f1")
			return err
		})
	}()

}

func TestUnwind(t *testing.T) {
	var clog cleanup.Steps
	a := []string{"init"}
	gold1 := []string{"init", "enter-f0", "enter-f1", "enter-f0", "exit-f1", "exit-f0", "exit-f0"}
	gold2 := []string{"init", "enter-f0", "enter-f1", "enter-f0", "exit-f1", "exit-f0", "exit-f0", "enter-f0", "exit-f0"}
	f0(&a, &clog, nil)
	f1(&a, &clog, nil)
	clog.Unwind()
	assert.Equal(t, gold1, a)
	f0(&a, &clog, nil)
	clog.Unwind()
	assert.Equal(t, gold2, a)
}

func TestUnwindWithErr(t *testing.T) {
	var clog cleanup.Steps
	err := errors.New("Force unwind error")
	a := []string{"init"}
	gold1 := []string{"init", "enter-f0", "enter-f1", "enter-f0", "exit-f1", "exit-f0", "exit-f0"}
	gold2 := []string{"init", "enter-f0", "enter-f1", "enter-f0", "exit-f1", "exit-f0", "exit-f0", "enter-f0", "exit-f0"}
	f0(&a, &clog, nil)
	f1(&a, &clog, err)
	assert.PanicsWithValue(t, err, func() { clog.Unwind() })
	assert.Equal(t, gold1, a)
	f0(&a, &clog, nil)
	clog.Unwind()
	assert.Equal(t, gold2, a)
}
