package disk

import (
	"a.yandex-team.ru/infra/rsm/diskmanager/pkg/mountinfo"
)

type MediaKind string

const (
	MediaKindUnknown      MediaKind = "unknown"
	MediaKindUnregistered MediaKind = "unregistered"
	MediaKindVirtual      MediaKind = "virtual"
	MediaKindPartition    MediaKind = "partition"
	MediaKindScsiDisk     MediaKind = "sd"
	MediaKindVirtIO       MediaKind = "vd"
	MediaKindMD           MediaKind = "md"
	MediaKindDeviceMapper MediaKind = "dm-"
	MediaKindLVolume      MediaKind = "lvol"
	MediaKindNVME         MediaKind = "nvme"
	MediaKindRAMDev       MediaKind = "ram"
	MediaKindNullBlk      MediaKind = "nullb"
	MediaKindLoopdev      MediaKind = "loop"
)

// Disk device representation, all sizes in bytes
type Disk struct {
	Kind             MediaKind
	Name             string
	DevPath          string
	SysfsPath        string
	Dev              uint64
	MajorMinor       string
	Size             uint64
	Model            string
	Serial           string
	Firmware         string
	WWN              string
	IsRotational     bool
	IsFinal          bool
	DiscardBlockSize uint64
	UdevEnv          map[string]string
	UdevLinks        []string
	UdevInitTS       uint64
	Backends         []string
	FinalBackends    []string
	FrontDisks       []string
	FrontMounts      []string
	Partition        uint
	PartStart        uint64
	PartUUID         string
	PartTableUUID    string
	PartDisk         string
	FsUUID           string
	FsLabel          string
	FsType           string
	FsErrCount       uint64
	LvName           string
	LvGroup          string
	MInfo            mountinfo.MountInfo
	Error            error //Error detected during collection
}

type SystemInfo struct {
	disks  []*Disk
	mounts []mountinfo.MountInfo
}
