package loop

import (
	"os"
	"os/user"
	"testing"

	"github.com/stretchr/testify/assert"
	"github.com/stretchr/testify/require"
)

const (
	devSize = uint64(128 << 20)
	devName = "test.img"
)

func TestLoopCreate(t *testing.T) {
	u, _ := user.Current()
	assert.NotNil(t, u)
	if u.Uid != "0" {
		t.Skipf("Test requires root privileges, current uid is: %s ", u.Uid)
	}
	lo, err := CreateTMPLoopDevice(devSize, devName)
	require.NoError(t, err)
	defer lo.Close()

	info, err := lo.lodev.GetInfo()
	assert.NoError(t, err)
	assert.Equal(t, uint64(0), info.Offset)
	assert.FileExists(t, lo.Path())
	loFi, _ := os.Stat(lo.Path())
	assert.Equal(t, os.ModeDevice, loFi.Mode()&os.ModeDevice)

	assert.FileExists(t, lo.BackingPath())
	fi, _ := os.Stat(lo.BackingPath())
	assert.Equal(t, devSize, uint64(fi.Size()))
}
