package lvm

import (
	"fmt"
)

type lvmError string
type lvmParseError string

func (s lvmError) Error() string {
	return string(s)
}
func (s lvmParseError) Error() string {
	return string(s)
}

func makeLvmParseError(format string, args ...interface{}) lvmParseError {
	return lvmParseError(fmt.Sprintf("ParseError "+format, args...))
}

const ErrNoSpace = lvmError("lvm: not enough free space")
const ErrTooFewDisks = lvmError("lvm: not enough underlying devices")
const ErrLogicalVolumeNotFound = lvmError("lvm: logical volume not found")
const ErrPhysicalVolumeNotFound = lvmError("lvm: physical volume not found")
const ErrVolumeGroupNotFound = lvmError("lvm: volume group not found")
const ErrInternal = lvmError("Internal error")
const ErrInvalidVGName = lvmError("lvm: Name contains invalid character, valid set includes: [A-Za-z0-9_+.-]")
const ErrInvalidLVName = lvmError("lvm: Name contains invalid character, valid set includes: [A-Za-z0-9_+.-]")
const ErrTagInvalidLength = lvmError("lvm: Tag length must be between 1 and 1024 characters")
const ErrTagHasInvalidChars = lvmError("lvm: Tag must consist of only [A-Za-z0-9_+.-] and cannot start with a '-'")
