package lvm

import (
	"github.com/stretchr/testify/assert"
	"testing"
)

func TestErrConst(t *testing.T) {
	assert := assert.New(t)
	err := lvmError("lvm: not enough free space")
	assert.Equal(err, ErrNoSpace)
}

func TestParseError(t *testing.T) {
	assert := assert.New(t)
	tok := []string{"one", "two", "three"}
	err := makeLvmParseError("expected %d tokens, got %d tokens:%v", 2, len(tok), tok)
	assert.Equal(err.Error(), "ParseError expected 2 tokens, got 3 tokens:[one two three]")
}
