package mountinfo

/*
  See http://man7.org/linux/man-pages/man5/proc.5.html

  303 23 0:44  /    /devel rw,relatime shared:161 - 9p   ARCADIA_ROOT         rw,sync,dirsync,access=client,trans=virtio
  52 24 252:42 /    /place rw,relatime shared:34 - ext4 /dev/mapper/hdd-place rw,quota,usrquota
  (1)(2)(3)   (4)   (5)      (6)       (7)      (8) (9) (10)                  (11)
  (1) mount ID:  unique identifier of the mount (may be reused after umount)
  (2) parent ID:  ID of parent (or of self for the top of the mount tree)
  (3) major:minor:  value of st_dev for files on filesystem
  (4) root:  root of the mount within the filesystem
  (5) mount point:  mount point relative to the process's root
  (6) mount options:  per mount options
  (7) optional fields:  zero or more fields of the form "tag[:value]"
  (8) separator:  marks the end of the optional fields
  (9) filesystem type:  name of filesystem of the form "type[.subtype]"
  (10) mount source:  filesystem specific information or "none"
  (11) super options:  per super block options
*/
type MountInfo struct {
	ID         uint32            /* 1 */
	Parent     uint32            /* 2 */
	Major      uint32            /* 3 */
	Minor      uint32            /* 3 */
	MajorMinor string            /* 3 */
	Root       string            /* 4 */
	Mountpoint string            /* 5 */
	Options    []string          /* 6 */
	Tags       map[string]string /* 7 */
	FsType     string            /* 9 */
	Source     string            /* 10*/
	FsOptions  []string          /* 11*/
}
