package mountinfo

import (
	"fmt"
	"testing"

	"github.com/stretchr/testify/assert"
)

func validateMount(t *testing.T, mList []MountInfo) {
	for _, m := range mList {
		fmt.Printf("validate %+v\n", m)
		assert.DirExists(t, m.Root)
		assert.DirExists(t, m.Mountpoint)
		assert.NotEqual(t, m.FsType, "")
		assert.NotEmpty(t, m.Options)
		assert.NotEmpty(t, m.FsOptions)
		/* TODO tags are not yet filled */
		assert.Empty(t, m.Tags)
	}
}

func TestParseSelf(t *testing.T) {
	mList, err := Self()
	assert.NoError(t, err)
	validateMount(t, mList)
}

func TestParsePidInit(t *testing.T) {
	mList, err := PID(1)
	assert.NoError(t, err)
	validateMount(t, mList)
}
