package sysfs

import (
	"testing"

	"github.com/stretchr/testify/assert"
	"github.com/stretchr/testify/require"
)

func TestCPU(t *testing.T) {
	maxCpus := Devices.Object("system").SubObject("cpu").Attribute("kernel_max")
	assert.NotNil(t, maxCpus)
	cpus, err := maxCpus.ReadUint64()
	assert.NoError(t, err)
	assert.NotZero(t, cpus)
}

func TestBlock(t *testing.T) {
	disks, err := Block.GetObjects()
	require.NoError(t, err)
	assert.NotEmpty(t, disks)

	disk := disks[0]
	_, err = disk.Attribute("size").ReadUint64()
	assert.NoError(t, err)

	partRange, err := disk.Attribute("range").ReadInt()
	assert.NoError(t, err)
	assert.NotZero(t, partRange)

	stat, err := disk.Attribute("stat").Read()
	assert.NoError(t, err)
	assert.NotEqual(t, stat, "")

	empty, err := disk.Attribute("NotExistingAttr").Read()
	assert.Error(t, err)
	assert.Equal(t, empty, "")

}
