package sysfs

import (
	"testing"

	"github.com/stretchr/testify/assert"
	"github.com/stretchr/testify/require"
)

func TestBlocks(t *testing.T) {
	disks, err := Block.GetObjects()
	require.NoError(t, err)
	assert.NotEmpty(t, disks)

	for _, disk := range disks {
		assert.True(t, disk.Exists())
		name, err := disk.Readlink()
		assert.NoError(t, err)
		assert.NotZero(t, name)
	}
}
