package sysfs

import (
	"io/ioutil"
)

type Subsystem string

var (
	Block       Subsystem = "/sys/block"
	Bus         Subsystem = "/sys/bus"
	Class       Subsystem = "/sys/class"
	Dev         Subsystem = "/sys/dev"
	Devices     Subsystem = "/sys/devices"
	Firmware    Subsystem = "/sys/firmware"
	FS          Subsystem = "/sys/fs"
	Hypervision Subsystem = "/sys/hypervisor"
	Kernel      Subsystem = "/sys/kernel"
	Module      Subsystem = "/sys/module"
	Power       Subsystem = "/sys/power"
)

func (subsys Subsystem) Name() string {
	return string(subsys)[5:]
}

func (subsys Subsystem) GetObjects() ([]Object, error) {
	files, err := ioutil.ReadDir(string(subsys))
	if err != nil {
		return nil, err
	}
	path := string(subsys) + "/"
	objects := make([]Object, 0)
	for _, dentry := range files {
		objects = append(objects, Object(path+dentry.Name()))
	}
	return objects, nil
}

func (subsys Subsystem) Object(name string) Object {
	return Object(string(subsys) + "/" + name)
}
