package udev

import (
	"fmt"
	"io/ioutil"
	"strings"
	"testing"

	"github.com/stretchr/testify/assert"
	"github.com/stretchr/testify/require"
)

func TestBlockDev(t *testing.T) {
	files, err := ioutil.ReadDir(UdevRoot)
	require.NoError(t, err)
	require.NotEmpty(t, files)

	for _, info := range files {
		if !strings.HasPrefix(info.Name(), "b") {
			continue
		}
		// info.Name() is 'b8:00' but we need only MajorMinor
		d := BlockDev(info.Name()[1:])
		e, err := d.Read()
		fmt.Printf("Parse dev:%s, info:%v", string(d), e)
		require.NoError(t, err)
		assert.NotEmpty(t, e.Links)
		assert.NotEmpty(t, e.Env)
		assert.NotZero(t, e.InitTS)
	}
}
