package pkg_test

import (
	"encoding/json"
	"io/ioutil"
	"os"
	"testing"

	"github.com/stretchr/testify/require"

	"a.yandex-team.ru/library/go/test/yatest"
)

func TestValidatePkg(t *testing.T) {
	var v interface{}
	pkgPath := yatest.SourcePath("infra/rsm/dnsmanager/build/packages/yandex-dns-manager/pkg.json")
	f, err := os.Open(pkgPath)
	require.NoError(t, err)
	defer f.Close()
	data, err := ioutil.ReadAll(f)
	require.NoError(t, err)

	err = json.Unmarshal(data, &v)
	require.NoErrorf(t, err, "Fail to parse package spec")
}
