package cmd

import (
	"bytes"
	"fmt"
	"github.com/spf13/cobra"
	"io/ioutil"
	"os"
	"path"
	"time"

	"a.yandex-team.ru/infra/rsm/dnsmanager/internal/named"
	"a.yandex-team.ru/library/go/core/resource"
)

const (
	resolvConfPath       = "/etc/resolv.conf"
	resolvConfPathCustom = "libcoredns/resolv.conf.custom"
	localTXTRecord       = "yandex-dns-manager.localhost"
)

func checkErr(err error) {
	if err != nil {
		fmt.Println(err)
		os.Exit(1)
	}
}

func registerCheck(root *cobra.Command) {
	cmd := &cobra.Command{
		Use:   "check",
		Short: "Monitoring check",
		Run: func(cmd *cobra.Command, args []string) {
			rcConfExp, err := ioutil.ReadFile(path.Join(confDir, resolvConfPathCustom))
			if os.IsNotExist(err) {
				rcConfExp = resource.Get(resolvConfPathCustom)
			}
			rcConfAct, err := ioutil.ReadFile(resolvConfPath)
			checkErr(err)
			if !bytes.Equal(rcConfExp, rcConfAct) {
				checkErr(fmt.Errorf("%s is abnormal", resolvConfPath))
			}

			checkErr(named.LookupCheck(
				localTXTRecord,
				[]string{"coredns"},
				"fd53::1", 53, 3*time.Second,
			))

			checkErr(named.LookupCheck(
				localTXTRecord,
				[]string{"coredns"},
				"fd64::1", 53, 3*time.Second,
			))
		},
	}

	root.AddCommand(cmd)
}
