package cmd

import (
	"github.com/spf13/cobra"

	"a.yandex-team.ru/infra/rsm/dnsmanager/internal/libcoredns"
)

func registerCoreDNS(root *cobra.Command) {
	cmd := &cobra.Command{
		Use:   "coredns",
		Short: "Run CoreDNS as local DNS cache server",
		PersistentPreRunE: func(cmd *cobra.Command, args []string) error {
			return setupLogger()
		},
		Run: func(cmd *cobra.Command, args []string) {
			libcoredns.NewCoreDNS(logger, confDir).Run()
		},
	}
	root.AddCommand(cmd)
}
