package dummy

import (
	"a.yandex-team.ru/infra/rsm/dnsmanager/pkg/iface"
)

type Dummy struct {
	ifaces []*iface.Dummy
}

func (d *Dummy) OnStartup() error {
	for _, i := range d.ifaces {
		if err := i.Create(); err != nil {
			return err
		}
	}
	return nil
}

func (d *Dummy) OnShutdown() error {
	for _, i := range d.ifaces {
		if err := i.Del(); err != nil {
			log.Error(err)
		}
	}
	return nil
}
