package dummy

import (
	"a.yandex-team.ru/infra/rsm/dnsmanager/internal/libcoredns/plugin"
	"a.yandex-team.ru/infra/rsm/dnsmanager/pkg/iface"

	"github.com/coredns/caddy"
	clog "github.com/coredns/coredns/plugin/pkg/log"
)

const namePlugin = "dummy"

var log = clog.NewWithPlugin(namePlugin)

func init() { plugin.Register(namePlugin, setup) }

func setup(c *caddy.Controller) error {
	d, err := parseDummy(c)
	if err != nil {
		return err
	}

	c.OnStartup(func() error {
		return d.OnStartup()
	})
	c.OnShutdown(func() error {
		return d.OnShutdown()
	})

	return nil
}

func parseDummy(c *caddy.Controller) (*Dummy, error) {
	d := &Dummy{}

	for c.Next() {
		args := c.RemainingArgs()
		if len(args) != 2 {
			return nil, c.ArgErr()
		}
		ifaceDummy, err := iface.NewDummy(args[0], args[1])
		if err != nil {
			return nil, err
		}
		d.ifaces = append(d.ifaces, ifaceDummy)
	}
	return d, nil
}
