package plugin

import (
	"github.com/coredns/caddy"
	"github.com/coredns/coredns/core/dnsserver"
)

// Directives (plugins) are registered in the order they should be executed.
// Ordering is VERY important. Every plugin will feel the effects of all other plugin below
// (after) them during a request, but they must not care what plugin above them are doing.
//
// This list of plugins copied from https://github.com/coredns/coredns/blob/master/core/dnsserver/zdirectives.go
// and extended with Yandex plugins (see arcadia/infra/rsm/dnsmanager/internal/libcoredns/plugin/).
func init() {
	dnsserver.Directives = []string{
		"metadata",
		"cancel",
		"tls",
		"reload",
		"nsid",
		"bufsize",
		"root",
		"dummy",
		"staticfile",
		"bind",
		"debug",
		"trace",
		"ready",
		"health",
		"pprof",
		"prometheus",
		"yasm",
		"errors",
		"log",
		"dnstap",
		"acl",
		"any",
		"chaos",
		"loadbalance",
		"cache",
		"rewrite",
		"dnssec",
		"autopath",
		"template",
		"transfer",
		"hosts",
		"route53",
		"azure",
		"clouddns",
		"federation",
		"k8s_external",
		"kubernetes",
		"file",
		"auto",
		"secondary",
		"etcd",
		"loop",
		"forward",
		"grpc",
		"erratic",
		"whoami",
		"on",
		"sign",
	}
}

func Register(name string, action caddy.SetupFunc) {
	caddy.RegisterPlugin(name, caddy.Plugin{
		ServerType: "dns",
		Action:     action,
	})
}
