package staticfile

import (
	"a.yandex-team.ru/infra/rsm/dnsmanager/internal/libcoredns/plugin"
	"a.yandex-team.ru/infra/rsm/dnsmanager/internal/named"

	"github.com/coredns/caddy"
	"github.com/coredns/coredns/core/dnsserver"
	clog "github.com/coredns/coredns/plugin/pkg/log"
)

const namePlugin = "staticfile"

var log = clog.NewWithPlugin(namePlugin)

func init() { plugin.Register(namePlugin, setup) }

func setup(c *caddy.Controller) error {
	sf, err := parseStaticFile(c)
	if err != nil {
		return err
	}

	c.OnStartup(func() error {
		return sf.OnStartup()
	})
	c.OnShutdown(func() error {
		return sf.OnShutdown()
	})

	return nil
}

func parseStaticFile(c *caddy.Controller) (*StaticFile, error) {
	sf := &StaticFile{}
	config := dnsserver.GetConfig(c)

	for c.Next() {
		if !c.NextArg() {
			return nil, c.ArgErr()
		}
		f := &File{}
		dstPath := c.Val()
		for c.NextBlock() {
			prop := c.Val()
			args := c.RemainingArgs()
			if len(args) != 1 {
				return nil, c.ArgErr()
			}
			switch prop {
			case "custom":
				customConf, err := named.NewConf(config.Root, args[0], dstPath)
				if err != nil {
					return nil, err
				}
				f.custom = customConf
			case "orig":
				origConf, err := named.NewConf(config.Root, args[0], dstPath)
				if err != nil {
					return nil, err
				}
				f.orig = origConf
			default:
				return sf, c.Errf("unknown property '%s'", prop)
			}
		}
		sf.files = append(sf.files, f)
	}
	return sf, nil
}
