package staticfile

import (
	"a.yandex-team.ru/infra/rsm/dnsmanager/internal/named"
)

type (
	StaticFile struct {
		files []*File
	}

	File struct {
		custom *named.Conf
		orig   *named.Conf
	}
)

func (sf *StaticFile) OnStartup() error {
	for _, f := range sf.files {
		if f.custom != nil {
			n, err := f.custom.Set()
			if err != nil {
				return err
			}
			if n != 0 {
				log.Infof("%s was changed", f.custom.Path())
			}
		}
	}
	return nil
}

func (sf *StaticFile) OnShutdown() error {
	for _, f := range sf.files {
		if f.orig != nil {
			n, err := f.orig.Set()
			if err != nil {
				return err
			}
			if n != 0 {
				log.Infof("%s was changed", f.orig.Path())
			}
		}
	}
	return nil
}
