package yasm

import (
	"net"

	"a.yandex-team.ru/infra/rsm/dnsmanager/internal/libcoredns/plugin"

	"github.com/coredns/caddy"
	clog "github.com/coredns/coredns/plugin/pkg/log"
)

const (
	namePlugin = "yasm"
	defaultURL = "127.0.0.1:11005"
)

var log = clog.NewWithPlugin(namePlugin)

func init() { plugin.Register(namePlugin, setup) }

func setup(c *caddy.Controller) error {
	y, err := parseYasm(c)
	if err != nil {
		return err
	}

	c.OnStartup(func() error {
		return y.OnStartup()
	})
	c.OnShutdown(func() error {
		return y.OnShutdown()
	})

	return nil
}

func parseYasm(c *caddy.Controller) (*Yasm, error) {
	y := New(defaultURL, make(Tags))

	c.Next()
	for c.NextBlock() {
		k := c.Val()
		args := c.RemainingArgs()
		switch k {
		case "url":
			v := args[0]
			_, _, err := net.SplitHostPort(v)
			if err != nil {
				return nil, err
			}
			y.URL = v
		case "itype", "ctype", "prj", "geo":
			y.Tags[k] = args[0]
		case "allow":
			if len(args) == 0 {
				return nil, c.ArgErr()
			}
			y.AddAllowedMetric(args[0], args[1:])
		case "name_replace":
			if len(args) != 2 {
				return nil, c.ArgErr()
			}
			y.AddNameReplace(args)
		case "label_replace":
			if len(args) != 2 {
				return nil, c.ArgErr()
			}
			y.AddLabelReplace(args)
		case "prfx":
			y.prfx = args[0]
		default:
			return nil, c.ArgErr()
		}

	}
	if y.Tags["itype"] == "" {
		return nil, c.ArgErr()
	}
	return y, nil
}
