package named

import (
	"context"
	"fmt"
	"net"
	"strconv"
	"time"
)

func DNSLookupTXT(req string, ip string, port int, t time.Duration) ([]string, error) {
	addr := net.JoinHostPort(ip, strconv.Itoa(port))
	r := &net.Resolver{
		Dial: func(ctx context.Context, _, _ string) (net.Conn, error) {
			return net.DialTimeout("udp", addr, t)
		},
	}
	return r.LookupTXT(context.TODO(), req)
}

func TCPPortCheck(ip string, port int, t time.Duration) error {
	addr := net.JoinHostPort(ip, strconv.Itoa(port))
	con, err := net.DialTimeout("tcp", addr, t)
	if err != nil {
		return err
	}
	return con.Close()
}

func LookupCheck(req string, vals []string, ip string, port int, t time.Duration) error {
	data, err := DNSLookupTXT(req, ip, port, t)
	if err != nil {
		return err
	} else if len(data) == 0 {
		return fmt.Errorf("error on resolv %s: TXT record NODATA", req)
	}
	for _, v := range vals {
		if data[0] == v {
			return nil
		}
	}
	return fmt.Errorf("error on resolv %s: TXT record is %s, but should be %s", req, data[0], vals)
}
