package pushyasm

import (
	"bytes"
	"context"
	"encoding/json"
	"fmt"
	"io/ioutil"
	"log"
	"net/http"
	"time"
)

type pushFormat struct {
	Tags interface{} `json:"tags"`
	//	TTL    int           `json:"ttl"`
	Values []Metric `json:"values"`
}

type Push struct {
	yasmHost string
	yasmPort int
	tags     map[string]string
	//	ttl      int
	client *http.Client
}

func NewPush(host string, port int, tags map[string]string) *Push {
	return &Push{
		yasmHost: host,
		yasmPort: port,
		tags:     tags,
		//		ttl:      5,
		client: &http.Client{Timeout: time.Second * 3},
	}
}

func (p *Push) MarshalJSON() ([]byte, error) {
	return json.Marshal([]*pushFormat{&pushFormat{
		Tags:   p.tags,
		Values: Reg.Get(),
	}})
}

func (p *Push) Run(ctx context.Context) {
	tick := time.NewTicker(time.Second * 5)
	for {
		select {
		case <-ctx.Done():
			return
		case <-tick.C:
			if err := p.send(ctx); err != nil {
				log.Println("error on sending data:", err)
			}
		}
	}
}

func (p *Push) send(ctx context.Context) error {
	data, err := json.Marshal(p)
	if err != nil {
		return err
	}
	log.Println("push metrics:", string(data))

	url := fmt.Sprintf("%s://%s:%d", "http", p.yasmHost, p.yasmPort)

	req, err := http.NewRequestWithContext(ctx, "POST", url, bytes.NewBuffer(data))
	if err != nil {
		return err
	}
	req.Header.Set("Content-Type", "application/json")
	resp, err := p.client.Do(req)
	if err != nil {
		return err
	}
	defer resp.Body.Close()
	if resp.StatusCode != 200 {
		body, _ := ioutil.ReadAll(resp.Body)
		return fmt.Errorf("http code %d %s", resp.StatusCode, string(body))
	}
	return nil
}
